/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterBlockNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatterBlockWithBeginNode
extends FormatterBlockNode {
    private IFormatterTextNode begin;

    public FormatterBlockWithBeginNode(IFormatterDocument document) {
        super(document);
    }

    @Override
    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean endWithNewLine;
        int blankLines;
        if (this.shouldConsumePreviousWhiteSpaces() && this.getSpacesCountBefore() > 0) {
            this.writeSpaces(visitor, context, this.getSpacesCountBefore());
        }
        if ((blankLines = context.getBlankLines()) > 0) {
            visitor.ensureLineStarted(context);
        }
        context.setBlankLines(this.getBlankLinesBefore(context));
        boolean addingNewLine = this.isAddingBeginNewLine();
        if (addingNewLine && !visitor.isInBlankLine()) {
            visitor.writeLineBreak(context);
        }
        if (this.begin != null) {
            this.begin.accept(context, visitor);
        }
        context.resetBlankLines();
        boolean indenting = this.isIndenting();
        if (indenting) {
            context.incIndent();
        }
        if ((endWithNewLine = this.isAddingEndNewLine()) && !visitor.endsWithNewLine()) {
            visitor.writeLineBreak(context);
        }
        super.accept(context, visitor);
        if (this.getSpacesCountAfter() > 0) {
            this.writeSpaces(visitor, context, this.getSpacesCountAfter());
        }
        if (indenting) {
            context.decIndent();
        }
        context.setBlankLines(this.getBlankLinesAfter(context));
    }

    protected int getBlankLinesBefore(IFormatterContext context) {
        return -1;
    }

    protected int getBlankLinesAfter(IFormatterContext context) {
        return -1;
    }

    public IFormatterTextNode getBegin() {
        return this.begin;
    }

    public void setBegin(IFormatterTextNode begin) {
        this.begin = begin;
    }

    @Override
    public int getStartOffset() {
        if (this.begin != null) {
            return this.begin.getStartOffset();
        }
        return super.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        if (!super.isEmpty()) {
            return super.getEndOffset();
        }
        if (this.begin != null) {
            return this.begin.getEndOffset();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.begin == null && super.isEmpty();
    }

    @Override
    public List<IFormatterNode> getChildren() {
        if (this.begin == null) {
            return super.getChildren();
        }
        ArrayList<IFormatterNode> result = new ArrayList<IFormatterNode>();
        if (this.begin != null) {
            result.add(this.begin);
        }
        result.addAll(super.getChildren());
        return result;
    }

    @Override
    public String toString() {
        return this.begin + "\n" + super.toString();
    }
}

